/* GemRB - Infinity Engine Emulator
 * Copyright (C) 2003 The GemRB Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

/**
 * @file DataFileMgr.h
 * Declares DataFileMgr class, abstract loader for .INI files
 * @author The GemRB Project
 */


#ifndef DATAFILEMGR_H
#define DATAFILEMGR_H

#include "Plugin.h"
#include "Streams/DataStream.h"

namespace GemRB {

/**
 * @class DataFileMgr
 * Abstract loader for .INI files
 */

class GEM_EXPORT DataFileMgr : public Plugin {
public:
	virtual bool Open(DataStream* stream) = 0;
	virtual int GetTagsCount() const = 0;
	virtual StringView GetTagNameByIndex(int index) const = 0;
	virtual int GetKeysCount(StringView Tag) const = 0;
	virtual StringView GetKeyNameByIndex(StringView Tag, int index) const = 0;
	virtual StringView GetKeyAsString(StringView Tag, StringView Key, StringView Default = StringView()) const = 0;
	virtual int GetKeyAsInt(StringView Tag, StringView Key, int Default) const = 0;
	virtual float GetKeyAsFloat(StringView Tag, StringView Key, float Default) const = 0;
	virtual bool GetKeyAsBool(StringView Tag, StringView Key, bool Default) const = 0;
};

}

#endif
