/* GemRB - Infinity Engine Emulator
 * Copyright (C) 2003 The GemRB Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

#ifndef IDSIMPORTER_H
#define IDSIMPORTER_H

#include "SymbolMgr.h"
#include "Strings/StringView.h"

#include <vector>

namespace GemRB {

class IDSImporter : public SymbolMgr {
private:
	struct Pair {
		int val;
		std::string str;
		
		Pair(int val, std::string str)
		: val(val), str(std::move(str))
		{}
	};

	std::vector<Pair> pairs;

public:
	IDSImporter() noexcept = default;

	bool Open(DataStream* stream) override;
	int GetValue(StringView txt) const override;
	const std::string& GetValue(int val) const override;
	const std::string& GetStringIndex(size_t Index) const override;
	int GetValueIndex(size_t Index) const override;
	int FindString(StringView str) const override;
	int FindValue(int val) const override;
	size_t GetSize() const override { return pairs.size(); }
	int GetHighestValue() const override;
};

#endif
}


