// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: internal/gitlab/api/api.proto

package api

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Configuration with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Configuration) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Configuration with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ConfigurationMultiError, or
// nil if none found.
func (m *Configuration) ValidateAll() error {
	return m.validate(true)
}

func (m *Configuration) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DefaultNamespace

	if all {
		switch v := interface{}(m.GetAccessAs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessAs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationValidationError{
				field:  "AccessAs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ConfigurationMultiError(errors)
	}

	return nil
}

// ConfigurationMultiError is an error wrapping multiple validation errors
// returned by Configuration.ValidateAll() if the designated constraints
// aren't met.
type ConfigurationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigurationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigurationMultiError) AllErrors() []error { return m }

// ConfigurationValidationError is the validation error returned by
// Configuration.Validate if the designated constraints aren't met.
type ConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigurationValidationError) ErrorName() string { return "ConfigurationValidationError" }

// Error satisfies the builtin error interface
func (e ConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfiguration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigurationValidationError{}

// Validate checks the field values on AllowedAgent with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AllowedAgent) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AllowedAgent with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AllowedAgentMultiError, or
// nil if none found.
func (m *AllowedAgent) ValidateAll() error {
	return m.validate(true)
}

func (m *AllowedAgent) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if m.GetConfigProject() == nil {
		err := AllowedAgentValidationError{
			field:  "ConfigProject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConfigProject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentValidationError{
					field:  "ConfigProject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentValidationError{
					field:  "ConfigProject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfigProject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentValidationError{
				field:  "ConfigProject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConfiguration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentValidationError{
					field:  "Configuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentValidationError{
					field:  "Configuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfiguration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentValidationError{
				field:  "Configuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AllowedAgentMultiError(errors)
	}

	return nil
}

// AllowedAgentMultiError is an error wrapping multiple validation errors
// returned by AllowedAgent.ValidateAll() if the designated constraints aren't met.
type AllowedAgentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AllowedAgentMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AllowedAgentMultiError) AllErrors() []error { return m }

// AllowedAgentValidationError is the validation error returned by
// AllowedAgent.Validate if the designated constraints aren't met.
type AllowedAgentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AllowedAgentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AllowedAgentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AllowedAgentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AllowedAgentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AllowedAgentValidationError) ErrorName() string { return "AllowedAgentValidationError" }

// Error satisfies the builtin error interface
func (e AllowedAgentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAllowedAgent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AllowedAgentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AllowedAgentValidationError{}

// Validate checks the field values on ConfigProject with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ConfigProject) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConfigProject with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ConfigProjectMultiError, or
// nil if none found.
func (m *ConfigProject) ValidateAll() error {
	return m.validate(true)
}

func (m *ConfigProject) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return ConfigProjectMultiError(errors)
	}

	return nil
}

// ConfigProjectMultiError is an error wrapping multiple validation errors
// returned by ConfigProject.ValidateAll() if the designated constraints
// aren't met.
type ConfigProjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigProjectMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigProjectMultiError) AllErrors() []error { return m }

// ConfigProjectValidationError is the validation error returned by
// ConfigProject.Validate if the designated constraints aren't met.
type ConfigProjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigProjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigProjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigProjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigProjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigProjectValidationError) ErrorName() string { return "ConfigProjectValidationError" }

// Error satisfies the builtin error interface
func (e ConfigProjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfigProject.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigProjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigProjectValidationError{}

// Validate checks the field values on Pipeline with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Pipeline) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Pipeline with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in PipelineMultiError, or nil
// if none found.
func (m *Pipeline) ValidateAll() error {
	return m.validate(true)
}

func (m *Pipeline) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return PipelineMultiError(errors)
	}

	return nil
}

// PipelineMultiError is an error wrapping multiple validation errors returned
// by Pipeline.ValidateAll() if the designated constraints aren't met.
type PipelineMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PipelineMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PipelineMultiError) AllErrors() []error { return m }

// PipelineValidationError is the validation error returned by
// Pipeline.Validate if the designated constraints aren't met.
type PipelineValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PipelineValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PipelineValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PipelineValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PipelineValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PipelineValidationError) ErrorName() string { return "PipelineValidationError" }

// Error satisfies the builtin error interface
func (e PipelineValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPipeline.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PipelineValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PipelineValidationError{}

// Validate checks the field values on Project with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Project) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Project with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ProjectMultiError, or nil if none found.
func (m *Project) ValidateAll() error {
	return m.validate(true)
}

func (m *Project) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	for idx, item := range m.GetGroups() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProjectValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProjectValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProjectValidationError{
					field:  fmt.Sprintf("Groups[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ProjectMultiError(errors)
	}

	return nil
}

// ProjectMultiError is an error wrapping multiple validation errors returned
// by Project.ValidateAll() if the designated constraints aren't met.
type ProjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProjectMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProjectMultiError) AllErrors() []error { return m }

// ProjectValidationError is the validation error returned by Project.Validate
// if the designated constraints aren't met.
type ProjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProjectValidationError) ErrorName() string { return "ProjectValidationError" }

// Error satisfies the builtin error interface
func (e ProjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProject.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProjectValidationError{}

// Validate checks the field values on Group with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Group) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Group with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GroupMultiError, or nil if none found.
func (m *Group) ValidateAll() error {
	return m.validate(true)
}

func (m *Group) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return GroupMultiError(errors)
	}

	return nil
}

// GroupMultiError is an error wrapping multiple validation errors returned by
// Group.ValidateAll() if the designated constraints aren't met.
type GroupMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GroupMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GroupMultiError) AllErrors() []error { return m }

// GroupValidationError is the validation error returned by Group.Validate if
// the designated constraints aren't met.
type GroupValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GroupValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GroupValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GroupValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GroupValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GroupValidationError) ErrorName() string { return "GroupValidationError" }

// Error satisfies the builtin error interface
func (e GroupValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGroup.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GroupValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GroupValidationError{}

// Validate checks the field values on Job with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Job) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Job with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in JobMultiError, or nil if none found.
func (m *Job) ValidateAll() error {
	return m.validate(true)
}

func (m *Job) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return JobMultiError(errors)
	}

	return nil
}

// JobMultiError is an error wrapping multiple validation errors returned by
// Job.ValidateAll() if the designated constraints aren't met.
type JobMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JobMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JobMultiError) AllErrors() []error { return m }

// JobValidationError is the validation error returned by Job.Validate if the
// designated constraints aren't met.
type JobValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JobValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JobValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JobValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JobValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JobValidationError) ErrorName() string { return "JobValidationError" }

// Error satisfies the builtin error interface
func (e JobValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJob.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JobValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JobValidationError{}

// Validate checks the field values on User with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *User) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on User with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in UserMultiError, or nil if none found.
func (m *User) ValidateAll() error {
	return m.validate(true)
}

func (m *User) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(m.GetUsername()) < 1 {
		err := UserValidationError{
			field:  "Username",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UserMultiError(errors)
	}

	return nil
}

// UserMultiError is an error wrapping multiple validation errors returned by
// User.ValidateAll() if the designated constraints aren't met.
type UserMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserMultiError) AllErrors() []error { return m }

// UserValidationError is the validation error returned by User.Validate if the
// designated constraints aren't met.
type UserValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserValidationError) ErrorName() string { return "UserValidationError" }

// Error satisfies the builtin error interface
func (e UserValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUser.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserValidationError{}

// Validate checks the field values on Environment with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Environment) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Environment with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in EnvironmentMultiError, or
// nil if none found.
func (m *Environment) ValidateAll() error {
	return m.validate(true)
}

func (m *Environment) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetSlug()) < 1 {
		err := EnvironmentValidationError{
			field:  "Slug",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetTier()) < 1 {
		err := EnvironmentValidationError{
			field:  "Tier",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EnvironmentMultiError(errors)
	}

	return nil
}

// EnvironmentMultiError is an error wrapping multiple validation errors
// returned by Environment.ValidateAll() if the designated constraints aren't met.
type EnvironmentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EnvironmentMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EnvironmentMultiError) AllErrors() []error { return m }

// EnvironmentValidationError is the validation error returned by
// Environment.Validate if the designated constraints aren't met.
type EnvironmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EnvironmentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EnvironmentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EnvironmentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EnvironmentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EnvironmentValidationError) ErrorName() string { return "EnvironmentValidationError" }

// Error satisfies the builtin error interface
func (e EnvironmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEnvironment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EnvironmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EnvironmentValidationError{}

// Validate checks the field values on GetAgentInfoResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetAgentInfoResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetAgentInfoResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetAgentInfoResponseMultiError, or nil if none found.
func (m *GetAgentInfoResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *GetAgentInfoResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetProjectId() <= 0 {
		err := GetAgentInfoResponseValidationError{
			field:  "ProjectId",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetAgentId() <= 0 {
		err := GetAgentInfoResponseValidationError{
			field:  "AgentId",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetAgentName()) < 1 {
		err := GetAgentInfoResponseValidationError{
			field:  "AgentName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetGitalyInfo() == nil {
		err := GetAgentInfoResponseValidationError{
			field:  "GitalyInfo",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetGitalyInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetAgentInfoResponseValidationError{
					field:  "GitalyInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetAgentInfoResponseValidationError{
					field:  "GitalyInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitalyInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetAgentInfoResponseValidationError{
				field:  "GitalyInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetGitalyRepository() == nil {
		err := GetAgentInfoResponseValidationError{
			field:  "GitalyRepository",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetGitalyRepository()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetAgentInfoResponseValidationError{
					field:  "GitalyRepository",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetAgentInfoResponseValidationError{
					field:  "GitalyRepository",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitalyRepository()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetAgentInfoResponseValidationError{
				field:  "GitalyRepository",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetDefaultBranch()) < 1 {
		err := GetAgentInfoResponseValidationError{
			field:  "DefaultBranch",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GetAgentInfoResponseMultiError(errors)
	}

	return nil
}

// GetAgentInfoResponseMultiError is an error wrapping multiple validation
// errors returned by GetAgentInfoResponse.ValidateAll() if the designated
// constraints aren't met.
type GetAgentInfoResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetAgentInfoResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetAgentInfoResponseMultiError) AllErrors() []error { return m }

// GetAgentInfoResponseValidationError is the validation error returned by
// GetAgentInfoResponse.Validate if the designated constraints aren't met.
type GetAgentInfoResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetAgentInfoResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetAgentInfoResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetAgentInfoResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetAgentInfoResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetAgentInfoResponseValidationError) ErrorName() string {
	return "GetAgentInfoResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetAgentInfoResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetAgentInfoResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetAgentInfoResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetAgentInfoResponseValidationError{}

// Validate checks the field values on GitalyInfo with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitalyInfo) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitalyInfo with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitalyInfoMultiError, or
// nil if none found.
func (m *GitalyInfo) ValidateAll() error {
	return m.validate(true)
}

func (m *GitalyInfo) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetAddress()) < 1 {
		err := GitalyInfoValidationError{
			field:  "Address",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Token

	// no validation rules for Features

	if len(errors) > 0 {
		return GitalyInfoMultiError(errors)
	}

	return nil
}

// GitalyInfoMultiError is an error wrapping multiple validation errors
// returned by GitalyInfo.ValidateAll() if the designated constraints aren't met.
type GitalyInfoMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitalyInfoMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitalyInfoMultiError) AllErrors() []error { return m }

// GitalyInfoValidationError is the validation error returned by
// GitalyInfo.Validate if the designated constraints aren't met.
type GitalyInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitalyInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitalyInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitalyInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitalyInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitalyInfoValidationError) ErrorName() string { return "GitalyInfoValidationError" }

// Error satisfies the builtin error interface
func (e GitalyInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitalyInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitalyInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitalyInfoValidationError{}

// Validate checks the field values on GitalyRepository with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *GitalyRepository) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitalyRepository with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GitalyRepositoryMultiError, or nil if none found.
func (m *GitalyRepository) ValidateAll() error {
	return m.validate(true)
}

func (m *GitalyRepository) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetStorageName()) < 1 {
		err := GitalyRepositoryValidationError{
			field:  "StorageName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetRelativePath()) < 1 {
		err := GitalyRepositoryValidationError{
			field:  "RelativePath",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetGlRepository()) < 1 {
		err := GitalyRepositoryValidationError{
			field:  "GlRepository",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetGlProjectPath()) < 1 {
		err := GitalyRepositoryValidationError{
			field:  "GlProjectPath",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GitalyRepositoryMultiError(errors)
	}

	return nil
}

// GitalyRepositoryMultiError is an error wrapping multiple validation errors
// returned by GitalyRepository.ValidateAll() if the designated constraints
// aren't met.
type GitalyRepositoryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitalyRepositoryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitalyRepositoryMultiError) AllErrors() []error { return m }

// GitalyRepositoryValidationError is the validation error returned by
// GitalyRepository.Validate if the designated constraints aren't met.
type GitalyRepositoryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitalyRepositoryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitalyRepositoryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitalyRepositoryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitalyRepositoryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitalyRepositoryValidationError) ErrorName() string { return "GitalyRepositoryValidationError" }

// Error satisfies the builtin error interface
func (e GitalyRepositoryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitalyRepository.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitalyRepositoryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitalyRepositoryValidationError{}

// Validate checks the field values on GetProjectInfoResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetProjectInfoResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetProjectInfoResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetProjectInfoResponseMultiError, or nil if none found.
func (m *GetProjectInfoResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *GetProjectInfoResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetProjectId() <= 0 {
		err := GetProjectInfoResponseValidationError{
			field:  "ProjectId",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetGitalyInfo() == nil {
		err := GetProjectInfoResponseValidationError{
			field:  "GitalyInfo",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetGitalyInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetProjectInfoResponseValidationError{
					field:  "GitalyInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetProjectInfoResponseValidationError{
					field:  "GitalyInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitalyInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetProjectInfoResponseValidationError{
				field:  "GitalyInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetGitalyRepository() == nil {
		err := GetProjectInfoResponseValidationError{
			field:  "GitalyRepository",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetGitalyRepository()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetProjectInfoResponseValidationError{
					field:  "GitalyRepository",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetProjectInfoResponseValidationError{
					field:  "GitalyRepository",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitalyRepository()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetProjectInfoResponseValidationError{
				field:  "GitalyRepository",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetDefaultBranch()) < 1 {
		err := GetProjectInfoResponseValidationError{
			field:  "DefaultBranch",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GetProjectInfoResponseMultiError(errors)
	}

	return nil
}

// GetProjectInfoResponseMultiError is an error wrapping multiple validation
// errors returned by GetProjectInfoResponse.ValidateAll() if the designated
// constraints aren't met.
type GetProjectInfoResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetProjectInfoResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetProjectInfoResponseMultiError) AllErrors() []error { return m }

// GetProjectInfoResponseValidationError is the validation error returned by
// GetProjectInfoResponse.Validate if the designated constraints aren't met.
type GetProjectInfoResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetProjectInfoResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetProjectInfoResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetProjectInfoResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetProjectInfoResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetProjectInfoResponseValidationError) ErrorName() string {
	return "GetProjectInfoResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetProjectInfoResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetProjectInfoResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetProjectInfoResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetProjectInfoResponseValidationError{}

// Validate checks the field values on AllowedAgentsForJob with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AllowedAgentsForJob) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AllowedAgentsForJob with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AllowedAgentsForJobMultiError, or nil if none found.
func (m *AllowedAgentsForJob) ValidateAll() error {
	return m.validate(true)
}

func (m *AllowedAgentsForJob) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAllowedAgents() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AllowedAgentsForJobValidationError{
						field:  fmt.Sprintf("AllowedAgents[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AllowedAgentsForJobValidationError{
						field:  fmt.Sprintf("AllowedAgents[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AllowedAgentsForJobValidationError{
					field:  fmt.Sprintf("AllowedAgents[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.GetJob() == nil {
		err := AllowedAgentsForJobValidationError{
			field:  "Job",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetJob()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Job",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Job",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetJob()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentsForJobValidationError{
				field:  "Job",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPipeline() == nil {
		err := AllowedAgentsForJobValidationError{
			field:  "Pipeline",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetPipeline()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Pipeline",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Pipeline",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPipeline()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentsForJobValidationError{
				field:  "Pipeline",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetProject() == nil {
		err := AllowedAgentsForJobValidationError{
			field:  "Project",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetProject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Project",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Project",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentsForJobValidationError{
				field:  "Project",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetUser() == nil {
		err := AllowedAgentsForJobValidationError{
			field:  "User",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetUser()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUser()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentsForJobValidationError{
				field:  "User",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetEnvironment()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Environment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AllowedAgentsForJobValidationError{
					field:  "Environment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnvironment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AllowedAgentsForJobValidationError{
				field:  "Environment",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AllowedAgentsForJobMultiError(errors)
	}

	return nil
}

// AllowedAgentsForJobMultiError is an error wrapping multiple validation
// errors returned by AllowedAgentsForJob.ValidateAll() if the designated
// constraints aren't met.
type AllowedAgentsForJobMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AllowedAgentsForJobMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AllowedAgentsForJobMultiError) AllErrors() []error { return m }

// AllowedAgentsForJobValidationError is the validation error returned by
// AllowedAgentsForJob.Validate if the designated constraints aren't met.
type AllowedAgentsForJobValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AllowedAgentsForJobValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AllowedAgentsForJobValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AllowedAgentsForJobValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AllowedAgentsForJobValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AllowedAgentsForJobValidationError) ErrorName() string {
	return "AllowedAgentsForJobValidationError"
}

// Error satisfies the builtin error interface
func (e AllowedAgentsForJobValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAllowedAgentsForJob.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AllowedAgentsForJobValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AllowedAgentsForJobValidationError{}

// Validate checks the field values on AuthorizeProxyUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AuthorizeProxyUserRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuthorizeProxyUserRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuthorizeProxyUserRequestMultiError, or nil if none found.
func (m *AuthorizeProxyUserRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *AuthorizeProxyUserRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetAgentId() <= 0 {
		err := AuthorizeProxyUserRequestValidationError{
			field:  "AgentId",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := _AuthorizeProxyUserRequest_AccessType_InLookup[m.GetAccessType()]; !ok {
		err := AuthorizeProxyUserRequestValidationError{
			field:  "AccessType",
			reason: "value must be in list [session_cookie]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetAccessKey()) < 1 {
		err := AuthorizeProxyUserRequestValidationError{
			field:  "AccessKey",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetCsrfToken()) < 1 {
		err := AuthorizeProxyUserRequestValidationError{
			field:  "CsrfToken",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AuthorizeProxyUserRequestMultiError(errors)
	}

	return nil
}

// AuthorizeProxyUserRequestMultiError is an error wrapping multiple validation
// errors returned by AuthorizeProxyUserRequest.ValidateAll() if the
// designated constraints aren't met.
type AuthorizeProxyUserRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuthorizeProxyUserRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuthorizeProxyUserRequestMultiError) AllErrors() []error { return m }

// AuthorizeProxyUserRequestValidationError is the validation error returned by
// AuthorizeProxyUserRequest.Validate if the designated constraints aren't met.
type AuthorizeProxyUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizeProxyUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizeProxyUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizeProxyUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizeProxyUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizeProxyUserRequestValidationError) ErrorName() string {
	return "AuthorizeProxyUserRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizeProxyUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizeProxyUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizeProxyUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizeProxyUserRequestValidationError{}

var _AuthorizeProxyUserRequest_AccessType_InLookup = map[string]struct{}{
	"session_cookie": {},
}

// Validate checks the field values on AuthorizeProxyUserResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AuthorizeProxyUserResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuthorizeProxyUserResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuthorizeProxyUserResponseMultiError, or nil if none found.
func (m *AuthorizeProxyUserResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *AuthorizeProxyUserResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetAgent() == nil {
		err := AuthorizeProxyUserResponseValidationError{
			field:  "Agent",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetAgent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AuthorizeProxyUserResponseValidationError{
				field:  "Agent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetUser() == nil {
		err := AuthorizeProxyUserResponseValidationError{
			field:  "User",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetUser()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUser()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AuthorizeProxyUserResponseValidationError{
				field:  "User",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetAccessAs() == nil {
		err := AuthorizeProxyUserResponseValidationError{
			field:  "AccessAs",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetAccessAs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AuthorizeProxyUserResponseValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessAs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AuthorizeProxyUserResponseValidationError{
				field:  "AccessAs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AuthorizeProxyUserResponseMultiError(errors)
	}

	return nil
}

// AuthorizeProxyUserResponseMultiError is an error wrapping multiple
// validation errors returned by AuthorizeProxyUserResponse.ValidateAll() if
// the designated constraints aren't met.
type AuthorizeProxyUserResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuthorizeProxyUserResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuthorizeProxyUserResponseMultiError) AllErrors() []error { return m }

// AuthorizeProxyUserResponseValidationError is the validation error returned
// by AuthorizeProxyUserResponse.Validate if the designated constraints aren't met.
type AuthorizeProxyUserResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizeProxyUserResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizeProxyUserResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizeProxyUserResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizeProxyUserResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizeProxyUserResponseValidationError) ErrorName() string {
	return "AuthorizeProxyUserResponseValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizeProxyUserResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizeProxyUserResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizeProxyUserResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizeProxyUserResponseValidationError{}

// Validate checks the field values on AuthorizedAgentForUser with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AuthorizedAgentForUser) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuthorizedAgentForUser with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuthorizedAgentForUserMultiError, or nil if none found.
func (m *AuthorizedAgentForUser) ValidateAll() error {
	return m.validate(true)
}

func (m *AuthorizedAgentForUser) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if m.GetConfigProject() == nil {
		err := AuthorizedAgentForUserValidationError{
			field:  "ConfigProject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConfigProject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AuthorizedAgentForUserValidationError{
					field:  "ConfigProject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AuthorizedAgentForUserValidationError{
					field:  "ConfigProject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfigProject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AuthorizedAgentForUserValidationError{
				field:  "ConfigProject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AuthorizedAgentForUserMultiError(errors)
	}

	return nil
}

// AuthorizedAgentForUserMultiError is an error wrapping multiple validation
// errors returned by AuthorizedAgentForUser.ValidateAll() if the designated
// constraints aren't met.
type AuthorizedAgentForUserMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuthorizedAgentForUserMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuthorizedAgentForUserMultiError) AllErrors() []error { return m }

// AuthorizedAgentForUserValidationError is the validation error returned by
// AuthorizedAgentForUser.Validate if the designated constraints aren't met.
type AuthorizedAgentForUserValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizedAgentForUserValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizedAgentForUserValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizedAgentForUserValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizedAgentForUserValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizedAgentForUserValidationError) ErrorName() string {
	return "AuthorizedAgentForUserValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizedAgentForUserValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizedAgentForUser.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizedAgentForUserValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizedAgentForUserValidationError{}

// Validate checks the field values on AccessAsProxyAuthorization with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AccessAsProxyAuthorization) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AccessAsProxyAuthorization with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AccessAsProxyAuthorizationMultiError, or nil if none found.
func (m *AccessAsProxyAuthorization) ValidateAll() error {
	return m.validate(true)
}

func (m *AccessAsProxyAuthorization) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofAccessAsPresent := false
	switch v := m.AccessAs.(type) {
	case *AccessAsProxyAuthorization_Agent:
		if v == nil {
			err := AccessAsProxyAuthorizationValidationError{
				field:  "AccessAs",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAccessAsPresent = true

		if m.GetAgent() == nil {
			err := AccessAsProxyAuthorizationValidationError{
				field:  "Agent",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAgent()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AccessAsProxyAuthorizationValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AccessAsProxyAuthorizationValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessAsProxyAuthorizationValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *AccessAsProxyAuthorization_User:
		if v == nil {
			err := AccessAsProxyAuthorizationValidationError{
				field:  "AccessAs",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAccessAsPresent = true

		if m.GetUser() == nil {
			err := AccessAsProxyAuthorizationValidationError{
				field:  "User",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUser()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AccessAsProxyAuthorizationValidationError{
						field:  "User",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AccessAsProxyAuthorizationValidationError{
						field:  "User",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUser()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessAsProxyAuthorizationValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofAccessAsPresent {
		err := AccessAsProxyAuthorizationValidationError{
			field:  "AccessAs",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AccessAsProxyAuthorizationMultiError(errors)
	}

	return nil
}

// AccessAsProxyAuthorizationMultiError is an error wrapping multiple
// validation errors returned by AccessAsProxyAuthorization.ValidateAll() if
// the designated constraints aren't met.
type AccessAsProxyAuthorizationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AccessAsProxyAuthorizationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AccessAsProxyAuthorizationMultiError) AllErrors() []error { return m }

// AccessAsProxyAuthorizationValidationError is the validation error returned
// by AccessAsProxyAuthorization.Validate if the designated constraints aren't met.
type AccessAsProxyAuthorizationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AccessAsProxyAuthorizationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AccessAsProxyAuthorizationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AccessAsProxyAuthorizationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AccessAsProxyAuthorizationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AccessAsProxyAuthorizationValidationError) ErrorName() string {
	return "AccessAsProxyAuthorizationValidationError"
}

// Error satisfies the builtin error interface
func (e AccessAsProxyAuthorizationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessAsProxyAuthorization.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AccessAsProxyAuthorizationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AccessAsProxyAuthorizationValidationError{}

// Validate checks the field values on AccessAsAgentAuthorization with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AccessAsAgentAuthorization) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AccessAsAgentAuthorization with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AccessAsAgentAuthorizationMultiError, or nil if none found.
func (m *AccessAsAgentAuthorization) ValidateAll() error {
	return m.validate(true)
}

func (m *AccessAsAgentAuthorization) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return AccessAsAgentAuthorizationMultiError(errors)
	}

	return nil
}

// AccessAsAgentAuthorizationMultiError is an error wrapping multiple
// validation errors returned by AccessAsAgentAuthorization.ValidateAll() if
// the designated constraints aren't met.
type AccessAsAgentAuthorizationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AccessAsAgentAuthorizationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AccessAsAgentAuthorizationMultiError) AllErrors() []error { return m }

// AccessAsAgentAuthorizationValidationError is the validation error returned
// by AccessAsAgentAuthorization.Validate if the designated constraints aren't met.
type AccessAsAgentAuthorizationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AccessAsAgentAuthorizationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AccessAsAgentAuthorizationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AccessAsAgentAuthorizationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AccessAsAgentAuthorizationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AccessAsAgentAuthorizationValidationError) ErrorName() string {
	return "AccessAsAgentAuthorizationValidationError"
}

// Error satisfies the builtin error interface
func (e AccessAsAgentAuthorizationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessAsAgentAuthorization.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AccessAsAgentAuthorizationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AccessAsAgentAuthorizationValidationError{}

// Validate checks the field values on AccessAsUserAuthorization with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AccessAsUserAuthorization) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AccessAsUserAuthorization with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AccessAsUserAuthorizationMultiError, or nil if none found.
func (m *AccessAsUserAuthorization) ValidateAll() error {
	return m.validate(true)
}

func (m *AccessAsUserAuthorization) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetProjects() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AccessAsUserAuthorizationValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AccessAsUserAuthorizationValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessAsUserAuthorizationValidationError{
					field:  fmt.Sprintf("Projects[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetGroups() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AccessAsUserAuthorizationValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AccessAsUserAuthorizationValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessAsUserAuthorizationValidationError{
					field:  fmt.Sprintf("Groups[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return AccessAsUserAuthorizationMultiError(errors)
	}

	return nil
}

// AccessAsUserAuthorizationMultiError is an error wrapping multiple validation
// errors returned by AccessAsUserAuthorization.ValidateAll() if the
// designated constraints aren't met.
type AccessAsUserAuthorizationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AccessAsUserAuthorizationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AccessAsUserAuthorizationMultiError) AllErrors() []error { return m }

// AccessAsUserAuthorizationValidationError is the validation error returned by
// AccessAsUserAuthorization.Validate if the designated constraints aren't met.
type AccessAsUserAuthorizationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AccessAsUserAuthorizationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AccessAsUserAuthorizationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AccessAsUserAuthorizationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AccessAsUserAuthorizationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AccessAsUserAuthorizationValidationError) ErrorName() string {
	return "AccessAsUserAuthorizationValidationError"
}

// Error satisfies the builtin error interface
func (e AccessAsUserAuthorizationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessAsUserAuthorization.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AccessAsUserAuthorizationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AccessAsUserAuthorizationValidationError{}

// Validate checks the field values on ProjectAccessCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ProjectAccessCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProjectAccessCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProjectAccessCFMultiError, or nil if none found.
func (m *ProjectAccessCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ProjectAccessCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return ProjectAccessCFMultiError(errors)
	}

	return nil
}

// ProjectAccessCFMultiError is an error wrapping multiple validation errors
// returned by ProjectAccessCF.ValidateAll() if the designated constraints
// aren't met.
type ProjectAccessCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProjectAccessCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProjectAccessCFMultiError) AllErrors() []error { return m }

// ProjectAccessCFValidationError is the validation error returned by
// ProjectAccessCF.Validate if the designated constraints aren't met.
type ProjectAccessCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProjectAccessCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProjectAccessCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProjectAccessCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProjectAccessCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProjectAccessCFValidationError) ErrorName() string { return "ProjectAccessCFValidationError" }

// Error satisfies the builtin error interface
func (e ProjectAccessCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProjectAccessCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProjectAccessCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProjectAccessCFValidationError{}

// Validate checks the field values on GroupAccessCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GroupAccessCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GroupAccessCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GroupAccessCFMultiError, or
// nil if none found.
func (m *GroupAccessCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GroupAccessCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	if len(errors) > 0 {
		return GroupAccessCFMultiError(errors)
	}

	return nil
}

// GroupAccessCFMultiError is an error wrapping multiple validation errors
// returned by GroupAccessCF.ValidateAll() if the designated constraints
// aren't met.
type GroupAccessCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GroupAccessCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GroupAccessCFMultiError) AllErrors() []error { return m }

// GroupAccessCFValidationError is the validation error returned by
// GroupAccessCF.Validate if the designated constraints aren't met.
type GroupAccessCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GroupAccessCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GroupAccessCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GroupAccessCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GroupAccessCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GroupAccessCFValidationError) ErrorName() string { return "GroupAccessCFValidationError" }

// Error satisfies the builtin error interface
func (e GroupAccessCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGroupAccessCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GroupAccessCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GroupAccessCFValidationError{}

// Validate checks the field values on AgentConfigurationRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AgentConfigurationRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AgentConfigurationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AgentConfigurationRequestMultiError, or nil if none found.
func (m *AgentConfigurationRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *AgentConfigurationRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetAgentId() <= 0 {
		err := AgentConfigurationRequestValidationError{
			field:  "AgentId",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetAgentConfig() == nil {
		err := AgentConfigurationRequestValidationError{
			field:  "AgentConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetAgentConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationRequestValidationError{
					field:  "AgentConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationRequestValidationError{
					field:  "AgentConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAgentConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationRequestValidationError{
				field:  "AgentConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AgentConfigurationRequestMultiError(errors)
	}

	return nil
}

// AgentConfigurationRequestMultiError is an error wrapping multiple validation
// errors returned by AgentConfigurationRequest.ValidateAll() if the
// designated constraints aren't met.
type AgentConfigurationRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AgentConfigurationRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AgentConfigurationRequestMultiError) AllErrors() []error { return m }

// AgentConfigurationRequestValidationError is the validation error returned by
// AgentConfigurationRequest.Validate if the designated constraints aren't met.
type AgentConfigurationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentConfigurationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentConfigurationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentConfigurationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentConfigurationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentConfigurationRequestValidationError) ErrorName() string {
	return "AgentConfigurationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AgentConfigurationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentConfigurationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentConfigurationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentConfigurationRequestValidationError{}
