/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserAddKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserAddKeyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserAddKeyDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserAddKeyRequest) {
            UserAddKeyRequest req = (UserAddKeyRequest)request;
            CreateAccessKeyRequest accessKeyRequest = new CreateAccessKeyRequest();
            accessKeyRequest.setUserName(req.getUserName());
            LOG.debug((Object)("Creating accesskey with request " + request));
            CreateAccessKeyResult result = this.getClient().createAccessKey(accessKeyRequest);
            LOG.info((Object)result.getAccessKey().getAccessKeyId());
            LOG.info((Object)result.getAccessKey().getSecretAccessKey());
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

