/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.digest.ContentDigests;
import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.writer.DataWriterFactory;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    private final SAMFileHeader samFileHeader;
    private int recordsPerSlice = 10000;
    private boolean preserveReadNames = true;
    private long globalRecordCounter = 0L;

    public ContainerFactory(SAMFileHeader samFileHeader, int recordsPerSlice) {
        this.samFileHeader = samFileHeader;
        this.recordsPerSlice = recordsPerSlice;
    }

    public Container buildContainer(List<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException, IOException {
        return this.buildContainer(records, null);
    }

    Container buildContainer(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) throws IllegalArgumentException, IllegalAccessException, IOException {
        long time1 = System.nanoTime();
        CompressionHeader header = new CompressionHeaderFactory().build(records, substitutionMatrix, this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate);
        header.APDelta = true;
        long time2 = System.nanoTime();
        header.readNamesIncluded = this.preserveReadNames;
        header.APDelta = true;
        ArrayList<Slice> slices = new ArrayList<Slice>();
        Container container = new Container();
        container.header = header;
        container.nofRecords = records.size();
        container.globalRecordCounter = this.globalRecordCounter;
        container.bases = 0L;
        container.blockCount = 0;
        long time3 = System.nanoTime();
        long lastGlobalRecordCounter = container.globalRecordCounter;
        for (int i = 0; i < records.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> sliceRecords = records.subList(i, Math.min(records.size(), i + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(sliceRecords, header);
            slice.globalRecordCounter = lastGlobalRecordCounter;
            lastGlobalRecordCounter += (long)slice.nofRecords;
            container.bases += slice.bases;
            slices.add(slice);
            if (container.sequenceId != -1 || slice.sequenceId == -1) continue;
            container.sequenceId = slice.sequenceId;
        }
        long time4 = System.nanoTime();
        container.slices = slices.toArray(new Slice[slices.size()]);
        ContainerFactory.calculateAlignmentBoundaries(container);
        container.buildHeaderTime = time2 - time1;
        container.buildSlicesTime = time4 - time3;
        this.globalRecordCounter += (long)records.size();
        return container;
    }

    private static void calculateAlignmentBoundaries(Container container) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Slice s : container.slices) {
            if (s.sequenceId == -1) continue;
            start = Math.min(start, s.alignmentStart);
            end = Math.max(end, s.alignmentStart + s.alignmentSpan);
        }
        if (start < Integer.MAX_VALUE) {
            container.alignmentStart = start;
            container.alignmentSpan = end - start;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> records, CompressionHeader header) throws IllegalArgumentException, IllegalAccessException, IOException {
        HashMap<Integer, ExposedByteArrayOutputStream> map = new HashMap<Integer, ExposedByteArrayOutputStream>();
        for (int id : header.externalIds) {
            map.put(id, new ExposedByteArrayOutputStream());
        }
        DataWriterFactory dataWriterFactory = new DataWriterFactory();
        ExposedByteArrayOutputStream bitBAOS = new ExposedByteArrayOutputStream();
        DefaultBitOutputStream bitOutputStream = new DefaultBitOutputStream(bitBAOS);
        Slice slice = new Slice();
        slice.nofRecords = records.size();
        int minAlStart = Integer.MAX_VALUE;
        int maxAlEnd = 0;
        slice.sequenceId = -1;
        ContentDigests hasher = ContentDigests.create(ContentDigests.ALL);
        for (CramCompressionRecord record : records) {
            slice.bases += (long)record.readLength;
            hasher.add(record);
            if (slice.sequenceId == -2 || record.alignmentStart == 0 || record.sequenceId == -1) continue;
            switch (slice.sequenceId) {
                case -1: {
                    slice.sequenceId = record.sequenceId;
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    if (slice.sequenceId == record.sequenceId) break;
                    slice.sequenceId = -1;
                }
            }
            minAlStart = Math.min(record.alignmentStart, minAlStart);
            maxAlEnd = Math.max(record.getAlignmentEnd(), maxAlEnd);
        }
        slice.sliceTags = hasher.getAsTags();
        if (slice.sequenceId == -2 || minAlStart == Integer.MAX_VALUE) {
            slice.alignmentStart = 0;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = minAlStart;
            slice.alignmentSpan = maxAlEnd - minAlStart + 1;
        }
        Writer writer = dataWriterFactory.buildWriter(bitOutputStream, map, header, slice.sequenceId);
        int prevAlStart = slice.alignmentStart;
        for (CramCompressionRecord record : records) {
            record.alignmentDelta = record.alignmentStart - prevAlStart;
            prevAlStart = record.alignmentStart;
            writer.write(record);
        }
        bitOutputStream.close();
        slice.coreBlock = Block.buildNewCore(bitBAOS.toByteArray());
        slice.external = new HashMap<Integer, Block>();
        for (Integer key : map.keySet()) {
            ExposedByteArrayOutputStream os = (ExposedByteArrayOutputStream)map.get(key);
            Block externalBlock = new Block();
            externalBlock.setContentId(key);
            externalBlock.setContentType(BlockContentType.EXTERNAL);
            ExternalCompressor compressor = header.externalCompressors.get(key);
            byte[] rawData = os.toByteArray();
            byte[] compressed = compressor.compress(rawData);
            externalBlock.setContent(rawData, compressed);
            externalBlock.setMethod(compressor.getMethod());
            slice.external.put(key, externalBlock);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }
}

