/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.activeregion;

import com.google.java.contract.Ensures;
import java.util.Collection;
import java.util.LinkedList;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.GenomeLocSortedSet;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.activeregion.ActivityProfile;
import org.broadinstitute.gatk.utils.activeregion.ActivityProfileState;

public class BandPassActivityProfile
extends ActivityProfile {
    public static final int MAX_FILTER_SIZE = 50;
    private static final double MIN_PROB_TO_KEEP_IN_FILTER = 1.0E-5;
    public static final double DEFAULT_SIGMA = 17.0;
    private final int filterSize;
    private final double sigma;
    private final double[] GaussianKernel;

    public BandPassActivityProfile(GenomeLocParser parser, GenomeLocSortedSet restrictToIntervals) {
        this(parser, restrictToIntervals, 50, 17.0, true);
    }

    public BandPassActivityProfile(GenomeLocParser parser, GenomeLocSortedSet restrictToIntervals, int maxFilterSize, double sigma) {
        this(parser, restrictToIntervals, maxFilterSize, sigma, true);
    }

    public BandPassActivityProfile(GenomeLocParser parser, GenomeLocSortedSet restrictToIntervals, int maxFilterSize, double sigma, boolean adaptiveFilterSize) {
        super(parser, restrictToIntervals);
        if (sigma < 0.0) {
            throw new IllegalArgumentException("Sigma must be greater than or equal to 0 but got " + sigma);
        }
        this.sigma = sigma;
        double[] fullKernel = BandPassActivityProfile.makeKernel(maxFilterSize, sigma);
        this.filterSize = adaptiveFilterSize ? BandPassActivityProfile.determineFilterSize(fullKernel, 1.0E-5) : maxFilterSize;
        this.GaussianKernel = BandPassActivityProfile.makeKernel(this.filterSize, sigma);
    }

    protected static int determineFilterSize(double[] kernel, double minProbToKeepInFilter) {
        int middle;
        int filterEnd;
        for (filterEnd = middle = (kernel.length - 1) / 2; filterEnd > 0 && !(kernel[filterEnd - 1] < minProbToKeepInFilter); --filterEnd) {
        }
        return middle - filterEnd;
    }

    protected static double[] makeKernel(int filterSize, double sigma) {
        int bandSize = 2 * filterSize + 1;
        double[] kernel = new double[bandSize];
        for (int iii = 0; iii < bandSize; ++iii) {
            kernel[iii] = MathUtils.normalDistribution(filterSize, sigma, iii);
        }
        return MathUtils.normalizeFromRealSpace(kernel);
    }

    @Override
    public int getMaxProbPropagationDistance() {
        return super.getMaxProbPropagationDistance() + this.filterSize;
    }

    @Ensures(value={"result >= 1"})
    public int getBandSize() {
        return 2 * this.filterSize + 1;
    }

    @Ensures(value={"result >= 0"})
    public int getFilteredSize() {
        return this.filterSize;
    }

    @Ensures(value={"result >= 0"})
    public double getSigma() {
        return this.sigma;
    }

    @Ensures(value={"result != null", "result.length == getBandSize()"})
    protected double[] getKernel() {
        return this.GaussianKernel;
    }

    @Override
    protected Collection<ActivityProfileState> processState(ActivityProfileState justAddedState) {
        LinkedList<ActivityProfileState> states = new LinkedList<ActivityProfileState>();
        for (ActivityProfileState superState : super.processState(justAddedState)) {
            if (superState.isActiveProb > 0.0) {
                for (int jjj = -this.filterSize; jjj <= this.filterSize; ++jjj) {
                    GenomeLoc loc = this.getLocForOffset(justAddedState.getLoc(), jjj);
                    if (loc == null) continue;
                    double newProb = superState.isActiveProb * this.GaussianKernel[jjj + this.filterSize];
                    states.add(new ActivityProfileState(loc, newProb));
                }
                continue;
            }
            states.add(justAddedState);
        }
        return states;
    }
}

