/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;

public class ConstantInstruction
extends Instruction
implements ConstantVisitor {
    public int constantIndex;
    public int constant;
    private int parameterStackDelta;
    private int typeStackDelta;

    public ConstantInstruction() {
    }

    public ConstantInstruction(byte by, int n) {
        this(by, n, 0);
    }

    public ConstantInstruction(byte by, int n, int n2) {
        this.opcode = by;
        this.constantIndex = n;
        this.constant = n2;
    }

    public ConstantInstruction copy(ConstantInstruction constantInstruction) {
        this.opcode = constantInstruction.opcode;
        this.constantIndex = constantInstruction.constantIndex;
        this.constant = constantInstruction.constant;
        return this;
    }

    @Override
    public byte canonicalOpcode() {
        return this.opcode == 19 ? (byte)18 : (byte)this.opcode;
    }

    @Override
    public Instruction shrink() {
        if (this.requiredConstantIndexSize() == 1) {
            if (this.opcode == 19) {
                this.opcode = (byte)18;
            }
        } else if (this.opcode == 18) {
            this.opcode = (byte)19;
        }
        return this;
    }

    @Override
    protected void readInfo(byte[] byArray, int n) {
        int n2 = this.constantIndexSize();
        int n3 = this.constantSize();
        this.constantIndex = ConstantInstruction.readValue(byArray, n, n2);
        this.constant = ConstantInstruction.readValue(byArray, n += n2, n3);
    }

    @Override
    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.constantIndexSize();
        int n3 = this.constantSize();
        if (this.requiredConstantIndexSize() > n2) {
            throw new IllegalArgumentException("Instruction has invalid constant index size (" + this.toString(n) + ")");
        }
        ConstantInstruction.writeValue(byArray, n, this.constantIndex, n2);
        ConstantInstruction.writeValue(byArray, n += n2, this.constant, n3);
    }

    @Override
    public int length(int n) {
        return 1 + this.constantIndexSize() + this.constantSize();
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, this);
    }

    @Override
    public int stackPopCount(Clazz clazz) {
        int n = super.stackPopCount(clazz);
        switch (this.opcode) {
            case -59: {
                n += this.constant;
                break;
            }
            case -77: 
            case -75: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                n += this.typeStackDelta;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                n += this.parameterStackDelta;
            }
        }
        return n;
    }

    @Override
    public int stackPushCount(Clazz clazz) {
        int n = super.stackPushCount(clazz);
        switch (this.opcode) {
            case -78: 
            case -76: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                n += this.typeStackDelta;
            }
        }
        return n;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        String string = fieldrefConstant.getType(clazz);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(string));
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        clazz.constantPoolEntryAccept(invokeDynamicConstant.u2nameAndTypeIndex, this);
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2nameAndTypeIndex, this);
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        clazz.constantPoolEntryAccept(methodrefConstant.u2nameAndTypeIndex, this);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        String string = nameAndTypeConstant.getType(clazz);
        this.parameterStackDelta = ClassUtil.internalMethodParameterSize(string);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(string));
    }

    public String toString() {
        return this.getName() + " #" + this.constantIndex + (this.constantSize() == 0 ? "" : ", " + this.constant);
    }

    private int constantIndexSize() {
        return this.opcode == 18 ? 1 : 2;
    }

    private int constantSize() {
        return this.opcode == -59 ? 1 : (this.opcode == -70 || this.opcode == -71 ? 2 : 0);
    }

    private int requiredConstantIndexSize() {
        return (this.constantIndex & 0xFF) == this.constantIndex ? 1 : ((this.constantIndex & 0xFFFF) == this.constantIndex ? 2 : 4);
    }
}

