/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class ExceptionInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor {
    private static final boolean DEBUG = false;
    private boolean mayThrowExceptions;

    public boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        return this.mayThrowExceptions(clazz, method, codeAttribute, 0, codeAttribute.u4codeLength);
    }

    public boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        return this.firstExceptionThrowingInstructionOffset(clazz, method, codeAttribute, n, n2) < n2;
    }

    public int firstExceptionThrowingInstructionOffset(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        Instruction instruction;
        byte[] byArray = codeAttribute.code;
        for (int i = n; i < n2; i += instruction.length(i)) {
            instruction = InstructionFactory.create(byArray, i);
            if (!this.mayThrowExceptions(clazz, method, codeAttribute, i, instruction)) continue;
            return i;
        }
        return n2;
    }

    public int lastExceptionThrowingInstructionOffset(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        byte[] byArray = codeAttribute.code;
        int n3 = n;
        int n4 = n;
        while (n4 < n2) {
            Instruction instruction = InstructionFactory.create(byArray, n4);
            if (this.mayThrowExceptions(clazz, method, codeAttribute, n4, instruction)) {
                n4 += instruction.length(n4);
                n3 = n4;
                continue;
            }
            n4 += instruction.length(n4);
        }
        return n3;
    }

    public boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        Instruction instruction = InstructionFactory.create(codeAttribute.code, n);
        return this.mayThrowExceptions(clazz, method, codeAttribute, n, instruction);
    }

    public boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        return instruction.mayThrowExceptions();
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -68: 
            case -66: 
            case -65: 
            case -62: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                this.mayThrowExceptions = true;
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: 
            case -69: 
            case -67: 
            case -64: 
            case -63: 
            case -59: {
                this.mayThrowExceptions = true;
            }
        }
    }
}

