########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Tuesday 27 November 2007 10:54:32 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/VisionLibraries/scipylib/signal/plotdb10FFT.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
# $Id: plotdb10FFT.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#

from NetworkEditor.macros import MacroNode
class plotdb10FFT(MacroNode):

    def __init__(self, constrkw={}, name='plotdb10FFT', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from Vision.matplotlibNodes import matplotliblib
        net.editor.addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

        from MyDefaultLib import mydefaultlib
        net.editor.addLibraryInstance(mydefaultlib,"MyDefaultLib", "mydefaultlib")


    def afterAddingToNetwork(self):
        masterNet = self.macroNetwork
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from Vision.matplotlibNodes import matplotliblib
        from MyDefaultLib import mydefaultlib
        ## building macro network ##
        plotdb10FFT_0 = self
        from traceback import print_exc
        ## loading libraries ##
        from Vision.matplotlibNodes import matplotliblib
        self.macroNetwork.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

        from MyDefaultLib import mydefaultlib
        self.macroNetwork.getEditor().addLibraryInstance(mydefaultlib,"MyDefaultLib", "mydefaultlib")

        try:
            ## saving node input Ports ##
            input_Ports_1 = self.macroNetwork.ipNode
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_1=None

        try:
            ## saving node output Ports ##
            output_Ports_2 = self.macroNetwork.opNode
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_2=None

        try:
            ## saving node Plot ##
            from Vision.matplotlibNodes import PlotNE
            Plot_3 = PlotNE(constrkw = {}, name='Plot', library=matplotliblib)
            self.macroNetwork.addNode(Plot_3,220,210)
        except:
            print "WARNING: failed to restore PlotNE named Plot in network self.macroNetwork"
            print_exc()
            Plot_3=None

        try:
            ## saving node db10FFT ##
            from MyDefaultLib.signal.db10FFT import db10FFT
            db10FFT_4 = db10FFT(constrkw = {}, name='db10FFT', library=mydefaultlib)
            self.macroNetwork.addNode(db10FFT_4,202,122)
            apply(db10FFT_4.inputPortByName['data'].configure, (), {'color': 'white'})
            apply(db10FFT_4.inputPortByName['fs'].configure, (), {'color': 'white'})
            apply(db10FFT_4.inputPortByName['nfft'].configure, (), {'color': 'white', 'shape': 'diamond'})
        except:
            print "WARNING: failed to restore db10FFT named db10FFT in network self.macroNetwork"
            print_exc()
            db10FFT_4=None

        self.macroNetwork.run()
        self.macroNetwork.freeze()

        ## saving connections for network plotdb10FFT ##
        if db10FFT_4 is not None and Plot_3 is not None:
            try:
                self.macroNetwork.connectNodes(
                    db10FFT_4, Plot_3, "out0", "y", blocking=True)
            except:
                print "WARNING: failed to restore connection between db10FFT_4 and Plot_3 in network self.macroNetwork"
        if db10FFT_4 is not None and Plot_3 is not None:
            try:
                self.macroNetwork.connectNodes(
                    db10FFT_4, Plot_3, "freqs", "x", blocking=True)
            except:
                print "WARNING: failed to restore connection between db10FFT_4 and Plot_3 in network self.macroNetwork"
        input_Ports_1 = self.macroNetwork.ipNode
        if input_Ports_1 is not None and db10FFT_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_1, db10FFT_4, "new", "data", blocking=True)
            except:
                print "WARNING: failed to restore connection between input_Ports_1 and db10FFT_4 in network self.macroNetwork"
        if input_Ports_1 is not None and db10FFT_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_1, db10FFT_4, "new", "fs", blocking=True)
            except:
                print "WARNING: failed to restore connection between input_Ports_1 and db10FFT_4 in network self.macroNetwork"
        output_Ports_2 = self.macroNetwork.opNode
        if Plot_3 is not None and output_Ports_2 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Plot_3, output_Ports_2, "plot", "new", blocking=True)
            except:
                print "WARNING: failed to restore connection between Plot_3 and output_Ports_2 in network self.macroNetwork"
        self.macroNetwork.unfreeze()

#self.macroNetwork.run()

        plotdb10FFT_0.shrink()

        ## reset modifications ##
        plotdb10FFT_0.resetTags()
        plotdb10FFT_0.buildOriginalList()
