/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyDescriptorUtils {
    PropertyDescriptorUtils() {
    }

    public static void copyNonMethodProperties(PropertyDescriptor source, PropertyDescriptor target) throws IntrospectionException {
        target.setExpert(source.isExpert());
        target.setHidden(source.isHidden());
        target.setPreferred(source.isPreferred());
        target.setName(source.getName());
        target.setShortDescription(source.getShortDescription());
        target.setDisplayName(source.getDisplayName());
        Enumeration<String> keys = source.attributeNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            target.setValue(key, source.getValue(key));
        }
        target.setPropertyEditorClass(source.getPropertyEditorClass());
        target.setBound(source.isBound());
        target.setConstrained(source.isConstrained());
    }

    public static Class<?> findPropertyType(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> propertyType = null;
        if (readMethod != null) {
            params = readMethod.getParameterTypes();
            if (params.length != 0) {
                throw new IntrospectionException("bad read method arg count: " + readMethod);
            }
            propertyType = readMethod.getReturnType();
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + readMethod.getName() + " returns void");
            }
        }
        if (writeMethod != null) {
            params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("bad write method arg count: " + writeMethod);
            }
            if (propertyType != null && !params[0].isAssignableFrom(propertyType)) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            propertyType = params[0];
        }
        return propertyType;
    }

    public static Class<?> findIndexedPropertyType(String name, Class<?> propertyType, Method indexedReadMethod, Method indexedWriteMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> indexedPropertyType = null;
        if (indexedReadMethod != null) {
            params = indexedReadMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            indexedPropertyType = indexedReadMethod.getReturnType();
            if (indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (indexedWriteMethod != null) {
            params = indexedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (indexedPropertyType != null && indexedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods: " + name);
            }
            indexedPropertyType = params[1];
        }
        if (!(propertyType == null || propertyType.isArray() && propertyType.getComponentType() == indexedPropertyType)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods: " + name);
        }
        return indexedPropertyType;
    }

    public static boolean equals(PropertyDescriptor pd1, Object obj) {
        if (pd1 == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyDescriptor) {
            PropertyDescriptor pd2 = (PropertyDescriptor)obj;
            if (!PropertyDescriptorUtils.compareMethods(pd1.getReadMethod(), pd2.getReadMethod())) {
                return false;
            }
            if (!PropertyDescriptorUtils.compareMethods(pd1.getWriteMethod(), pd2.getWriteMethod())) {
                return false;
            }
            if (pd1.getPropertyType() == pd2.getPropertyType() && pd1.getPropertyEditorClass() == pd2.getPropertyEditorClass() && pd1.isBound() == pd2.isBound() && pd1.isConstrained() == pd2.isConstrained()) {
                return true;
            }
        }
        return false;
    }

    public static boolean compareMethods(Method a, Method b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || b == null || a.equals(b);
    }
}

