#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Escape Goat 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20230125.2

GAME_ID='escape-goat-2'
GAME_NAME='Escape Goat 2'

ARCHIVE_BASE_0='gog_escape_goat_2_2.0.0.11.sh'
ARCHIVE_BASE_0_MD5='50e77abfe8737c6d0e1e37e8ad2460cc'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='260000'
ARCHIVE_BASE_0_VERSION='1.1.0-gog2.0.0.11'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/escape_goat_2'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Content
fr
mono
EscapeGoat2.exe
Escape Goat 2.bmp
Common.dll
EG2.ICSharpCode.SharpZipLib.dll
EG2.Newtonsoft.Json.dll
EscapeGoat2.resources.dll
Illuminant.dll
MonoGame.Framework.dll
Physics.dll
SDL2-CS.dll
SDL2-CS.dll.config
Squared.*.dll'
CONTENT_DOC_MAIN_FILES='
Linux.README
ReadMe.txt'

APP_MAIN_EXE='EscapeGoat2.exe'
APP_MAIN_ICON='Escape Goat 2.bmp'

PKG_MAIN_DEPS='mono'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libopenal.so.1
libSDL2-2.0.so.0'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
I18N.dll
I18N.West.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll
System.Xml.Linq.dll'

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
