#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Tiny Bang Story
# send your bug reports to contact@dotslashplay.it
###

script_version=20240623.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='the-tiny-bang-story'
GAME_NAME='The Tiny Bang Story'

# Game archives

## French version

ARCHIVE_BASE_FR_1_NAME='setup_the_tiny_bang_story_gog-1(a)_(french)_(23028).exe'
ARCHIVE_BASE_FR_1_MD5='e66f1b4bf1eb19b1e569a38d897e3f27'
ARCHIVE_BASE_FR_1_TYPE='innosetup'
ARCHIVE_BASE_FR_1_SIZE='200000'
ARCHIVE_BASE_FR_1_VERSION='1.0-gog23028'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/the_tiny_bang_story'

## English version

ARCHIVE_BASE_EN_1_NAME='setup_the_tiny_bang_story_gog-1(a)_(23028).exe'
ARCHIVE_BASE_EN_1_MD5='a416471e10da3b374f4f43664cc4f179'
ARCHIVE_BASE_EN_1_TYPE='innosetup'
ARCHIVE_BASE_EN_1_SIZE='200000'
ARCHIVE_BASE_EN_1_VERSION='1.0-gog23028'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/the_tiny_bang_story'

ARCHIVE_BASE_EN_0_NAME='setup_the_tiny_bang_story_gog-1_(22449).exe'
ARCHIVE_BASE_EN_0_MD5='7b4e54787f46f81242e39f16f75fd8f0'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='190000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog22449'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
game.exe'
CONTENT_GAME_L10N_FILES='
assets/strings.xml'
CONTENT_GAME_DATA_FILES='
assets'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Colibri Games/The Tiny Bang Story'

APP_MAIN_EXE='game.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
