#!/bin/sh
set -o errexit
set -o nounset

# Copy installed files from the system
mkdir --parents \
	"$AUTOPKGTEST_TMP/lib" \
	"$AUTOPKGTEST_TMP/man/man6" \
	"$AUTOPKGTEST_TMP/man/fr/man6"
cp /usr/share/games/play.it/libplayit2.sh "$AUTOPKGTEST_TMP/lib"
cp /usr/games/play.it "$AUTOPKGTEST_TMP"
gunzip --to-stdout --keep /usr/share/man/man6/play.it.6.gz > "$AUTOPKGTEST_TMP/man/man6/play.it.6"
gunzip --to-stdout --keep /usr/share/man/fr/man6/play.it.6.gz > "$AUTOPKGTEST_TMP/man/fr/man6/play.it.6"

# Copy test scripts from the source tree
cp Makefile "$AUTOPKGTEST_TMP"
cp --recursive tests "$AUTOPKGTEST_TMP"

# Run the tests
cd "$AUTOPKGTEST_TMP"
make check

exit 0
