/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;

public final class UpdateFieldOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected int fieldId;
    protected transient ByteArray preparedLog;

    public UpdateFieldOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int n3, Object object, LogicalUndo logicalUndo) throws StandardException {
        super(basePage, logicalUndo, n2);
        this.doMeSlot = n;
        this.fieldId = n3;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, object);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public UpdateFieldOperation() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        CompressedNumber.writeInt(objectOutput, this.fieldId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.fieldId = CompressedNumber.readInt(objectInput);
    }

    public int getTypeFormatId() {
        return 109;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.storeField(logInstant, this.doMeSlot, this.fieldId, limitObjectInput);
    }

    public void undoMe(Transaction transaction, BasePage basePage, int n, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n2 = basePage.findRecordById(n, 0);
        basePage.skipField(limitObjectInput);
        basePage.storeField(logInstant, n2, this.fieldId, limitObjectInput);
        basePage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreLoggedRow(Object[] objectArray, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        BasePage basePage = null;
        try {
            basePage = (BasePage)this.getContainer().getPage(this.getPageId().getPageNumber());
            basePage.skipField(limitObjectInput);
            basePage.skipField(limitObjectInput);
            basePage.restoreRecordFromStream(limitObjectInput, objectArray);
        }
        finally {
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
        }
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = basePage.findRecordById(this.recordId, 0);
        basePage.skipField(limitObjectInput);
        basePage.storeField(logInstant, n, this.fieldId, limitObjectInput);
        basePage.setAuxObject(null);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, Object object) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n = dynamicByteArrayOutputStream.getPosition();
        this.page.logColumn(this.doMeSlot, this.fieldId, object, dynamicByteArrayOutputStream, 100);
        this.page.logField(this.doMeSlot, this.fieldId, dynamicByteArrayOutputStream);
        if (this.undo != null) {
            this.page.logRecord(this.doMeSlot, 0, this.recordId, null, dynamicByteArrayOutputStream, null);
        }
        int n2 = dynamicByteArrayOutputStream.getPosition() - n;
        dynamicByteArrayOutputStream.setPosition(n);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n, n2);
    }

    public String toString() {
        return null;
    }
}

